// Plyr player

document.querySelectorAll('.plyr-player').forEach(item => {
  if (item.contains(item.querySelector('track'))) {
    let caption = item.querySelector('track');
    let lang = caption.getAttribute('src').split('/').pop().split('.')[0];
    caption.setAttribute('srclang', lang);
    caption.setAttribute('label', lang);
    item.setAttribute('data-plyr-config', `{ "captions": {"active" : true, "language" : "${lang}"} }`);
  }
});

const players = Plyr.setup('.plyr-player');


// Max width

location.search.substr(1).split('&').forEach(function(e){
  if (e.split('=')[0] == 'container' && e.split('=')[1] == 'max'){
    document.getElementById('container').className = 'container-fluid';
  }
});

// Processor bullets

if ($('.processor span').is('span')){
  $('.processor span').html($('.processor span').html().replace('<b>', '<h2>').replace('</b><br><br>', '</h2>').replace(/<br>-/g, '<br>&bull;'));
}

// Slider

$('.single-item').slick({
  infinite: true,
  dots: true,
  prevArrow: '<i class="slick-prev fas fa-chevron-left"></i>',
  nextArrow: '<i class="slick-next fas fa-chevron-right"></i>'
});

$('.multiple-items').slick({
  infinite: true,
  dots: true,
  slidesToShow: 4,
  slidesToScroll: 4,
  prevArrow: '<i class="slick-prev fas fa-chevron-left"></i>',
  nextArrow: '<i class="slick-next fas fa-chevron-right"></i>'
});

// HotSpot

$(function(){
  $('[data-toggle="popover"]').popover();
});

// Matomo track attributes

document.querySelectorAll('.video').forEach(item => {
  if (item.contains(item.querySelector('source'))) {
    let src = item.querySelector('source').getAttribute('src');
    item.setAttribute('data-track-content', '');
    item.setAttribute('data-content-name', 'video');
    item.setAttribute('data-content-piece', src);
  }
});

document.querySelectorAll('#container > .row:not(.video)').forEach(item => {
  let classList = item.classList;
  if (classList.length > 1) {
    let name = classList[--classList.length];
    item.setAttribute('data-track-content-impression', '');
    item.setAttribute('data-content-name', 'block');
    item.setAttribute('data-content-piece', name);
  }
});

document.querySelectorAll('.slick-arrow, .slick-dots button, .hotspot a').forEach(item => {
  if (item.classList.contains('slick-arrow')) {
    item.setAttribute('data-track-content-interaction', '');
    item.setAttribute('data-content-name', 'block');
    item.setAttribute('data-content-piece', 'slider-arrow');
  }  else if (item.matches('button')) {
    item.setAttribute('data-track-content-interaction', '');
    item.setAttribute('data-content-name', 'block');
    item.setAttribute('data-content-piece', 'slider-dot');
  }  else if (item.matches('a')) {
    item.setAttribute('data-track-content-interaction', '');
    item.setAttribute('data-content-name', 'block');
    item.setAttribute('data-content-piece', 'hotspot');
  }
});